
// ----------------------------------------------------------------------
// wdog.c
//
// Author: Aldo Giove - Gi. Com. srl - Brindisi - Italy
// ----------------------------------------------------------------------

#include "wdog.h"
#include "enumproc.h"

#include <stdio.h>
#include <windowsx.h>

#define MAX_LOADSTRING 100

// Global Variables:
HINSTANCE hInst = NULL,
          hInstIntlDll = NULL;
TCHAR szTitle[MAX_LOADSTRING];					
LPCSTR szWindowClass = "WDOG";
TCHAR szNomeFileIni[_MAX_PATH];
TCHAR szNomePathEseguibile[_MAX_PATH];
BOOL fWarning = FALSE;
HMENU hMenu = NULL;

// Forward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK    fnDlgElencoProcessi(HWND hDlg, UINT message, 
                                        WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK    fnDlgOpzioni(HWND hDlg, UINT message, 
                                 WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK    fnDlgInput(HWND hDlg, UINT message, 
                               WPARAM wParam, LPARAM lParam);
void                leggiOpzioni(void);

// ------------------------------------

#define NMAXSNAPSHOTPROCESSI 1000

typedef struct
{
    char dataOra[20];
    int nProcessi;
    DWORD idProcessi[NMAXSNAPSHOTPROCESSI];
    char *processi[NMAXSNAPSHOTPROCESSI]; // Allocati con malloc()
} SnapshotProcessi;

SnapshotProcessi *snapshotAttuale = NULL,
                 *snapshotPrecedente = NULL;

// ------------------------------------

#define NMAXPROCESSI 200
#define NMAXFILES NMAXPROCESSI

#define UWM_NOTIFICAICONA WM_USER + 1

// ------------------------------------

// Funzioni per scrivere e leggere le opzioni dal registry

#define LEGGIOPZIONESTRINGA(k) \
{ \
    datiPreferenze.k = malloc(256); \
    GetPrivateProfileString(szWindowClass, #k, "", datiPreferenze.k, 256, szNomeFileIni); \
}

#define LEGGIOPZIONESTRINGA_IDX(k, i) \
{ \
    char s[120]; \
    sprintf(s, #k "_%d",  i); \
    datiPreferenze.k[i] = malloc(256); \
    GetPrivateProfileString(szWindowClass, s, "", datiPreferenze.k[i], 256, szNomeFileIni); \
}

#define LEGGIOPZIONEINT(k) \
{ \
    char s[20]; \
    GetPrivateProfileString(szWindowClass, #k, "0", s, 20, szNomeFileIni); \
    datiPreferenze.k = atoi(s); \
}

#define SCRIVIOPZIONESTRINGA_IDX(k, i) \
{ \
    char s[120]; \
    sprintf(s, #k "_%d", i); \
    WritePrivateProfileString(szWindowClass, s, datiPreferenze.k[i], szNomeFileIni); \
}

#define SCRIVIOPZIONESTRINGA(k) \
{ \
    WritePrivateProfileString(szWindowClass, #k, datiPreferenze.k, szNomeFileIni); \
}

#define SCRIVIOPZIONEINT(k) \
{ \
    char s[20]; \
    itoa(datiPreferenze.k, s, 10); \
    WritePrivateProfileString(szWindowClass, #k, s, szNomeFileIni); \
}

// ------------------------------------

struct
{
    BOOL fInizializzato;
    LPSTR lpszIntlDll;
    BOOL fProcessiOn,
         fFilesOn;
    WORD nProcessi,
         nFiles;
    LPSTR lpszNomiProcessi[NMAXPROCESSI],
          lpszNomiFiles[NMAXFILES];
} datiPreferenze;

// ------------------------------------

typedef struct
{
    LPCSTR prompt,
           titolo;
    LPSTR valore;
} DatiInputStringa;

// ------------------------------------

void errore(LPCSTR msg)
{
    MessageBox(NULL, msg, szTitle, MB_ICONHAND|MB_APPLMODAL);
}

// ------------------------------------

BOOL sicuro(LPCSTR s)
{
    int r;
    r = MessageBox(NULL, s, szTitle, 
                   MB_APPLMODAL|MB_ICONQUESTION|MB_YESNO);
    return (r == IDYES);
}

// ------------------------------------

void messaggio(LPCSTR s)
{
    MessageBox(NULL, s, szTitle, MB_ICONINFORMATION|MB_APPLMODAL);
}

// ------------------------------------

void erroreWindows(LPCSTR msg)
{
    char s[250];
    sprintf(s, "Windows error %ld in %s.", GetLastError, msg);
    MessageBox(NULL, s, szTitle, MB_ICONHAND|MB_APPLMODAL);
}

// ------------------------------------

LPCSTR qualeDataOra(void)
{
    static TCHAR s[20];
    SYSTEMTIME st;
    
    GetLocalTime(&st);
    sprintf(s, "%04d/%02d/%02d %02d:%02d:%02d",
               st.wYear, st.wMonth, st.wDay, 
               st.wHour, st.wMinute, st.wSecond);

    return s;
}

// ------------------------------------

LPCSTR inputStringa(HWND hWnd, LPCSTR prompt, LPCSTR titolo, LPCSTR valoreDefault)
{
    static TCHAR s[256];
    DatiInputStringa d;
    int retval;

    d.prompt = prompt;
    d.titolo = titolo;
    d.valore = s;

    strcpy(s, valoreDefault);

    retval = DialogBoxParam(hInstIntlDll, (LPCTSTR)IDD_INPUT, hWnd, 
                           (DLGPROC)fnDlgInput, (LPARAM)&d);

    return s;
}

// ------------------------------------

void unloadResourceDll(void)
{
    if (hInstIntlDll && hInstIntlDll != hInst)
        FreeLibrary(hInstIntlDll);
    hInstIntlDll = hInst;
}

// ------------------------------------

void loadResourceDll(void)
{
    unloadResourceDll();

    if (*datiPreferenze.lpszIntlDll)
    {
        TCHAR s[_MAX_PATH];
        sprintf(s, "%s%s_%s.DLL", szNomePathEseguibile, szWindowClass,
                datiPreferenze.lpszIntlDll);
        hInstIntlDll = LoadLibrary(s);
        if (!hInstIntlDll)
        {
            hInstIntlDll = hInst;
            strcat(s, ": not found. Using default language.");
            errore(s);
        }
    }

    // Carica il menu
    if (hMenu)
        DestroyMenu(hMenu);
    hMenu = LoadMenu(hInstIntlDll, MAKEINTRESOURCE(IDC_WDOG));
}

// ------------------------------------

void loadResourceString(int id, LPSTR s, int maxLen)
{
    int retval = LoadString(hInstIntlDll, id, s, maxLen);
    if (!retval)
    {
        TCHAR msg[120];
        sprintf(msg, "Error loading resource string #%d.", id);
        errore(msg);
        s[0] = '\0';
    }
}

// ------------------------------------

LPCSTR getResourceString(int id)
{
    static TCHAR s[1024];
    loadResourceString(id, s, sizeof(s));
    return s;
}

// ------------------------------------

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
    MSG msg;
    
    // Initialize global strings
//    LoadString(hInstance, IDC_WDOG, szWindowClass, MAX_LOADSTRING);

    MyRegisterClass(hInstance);

    // Perform application initialization:
    if (!InitInstance (hInstance, nCmdShow)) 
        return -1;

    // Main message loop:
    while (GetMessage(&msg, NULL, 0, 0)) 
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    
    return msg.wParam;
}


//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage is only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
    WNDCLASSEX wcex;

    memset(&wcex, 0, sizeof(wcex));
    
    wcex.cbSize = sizeof(WNDCLASSEX); 
    
    wcex.style			= CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc	= (WNDPROC)WndProc;
    wcex.cbClsExtra		= 0;
    wcex.cbWndExtra		= 0;
    wcex.hInstance		= hInstance;
//    wcex.hIcon			= LoadIcon(hInstance, (LPCTSTR)IDI_WDOG);
//    wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
//    wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
//    wcex.lpszMenuName	= (LPCSTR)IDC_WDOG;
    wcex.lpszClassName	= szWindowClass;
//    wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);
    
    return RegisterClassEx(&wcex);
}

// -------------------------------------------

void aggiornaIconaTray(HWND hWnd)
{
    static HICON hIconNormale = NULL;
    static HICON hIconWarning = NULL;
    static HICON hIcon = NULL;
    NOTIFYICONDATA nid;
    DWORD msg = NIM_ADD;

    if (!hIconNormale)
        hIconNormale = LoadIcon(hInst, MAKEINTRESOURCE(IDI_WDOG));
    if (!hIconWarning)
        hIconWarning = LoadIcon(hInst, MAKEINTRESOURCE(IDI_WDOGWARNING));
    if (!hIcon)
        hIcon = hIconNormale;

    if (fWarning && (hIcon == hIconNormale))
    {
        msg = NIM_MODIFY;
        hIcon = hIconWarning;
    }

    memset(&nid, 0, sizeof(nid));

    nid.cbSize = sizeof(nid);
    nid.hWnd = hWnd;
    nid.uID = 1;
    nid.uFlags = NIF_ICON|NIF_MESSAGE|NIF_TIP;
    nid.uCallbackMessage = UWM_NOTIFICAICONA;
    nid.hIcon = hIcon;
    strcpy(nid.szTip, szTitle);
    if (fWarning)
        strcat(nid.szTip, getResourceString(IDS_WARNINGICON));

    Shell_NotifyIcon(msg, &nid);
}

// -------------------------------------------

FILE *apriLog(void)
{
    TCHAR sf[_MAX_PATH];
    FILE *f;
    
    sprintf(sf, "%s%s.LOG", szNomePathEseguibile, szWindowClass);
    f = fopen(sf, "a+t");

    if (!f)
        errore("Error opening output log file.");

    return f;
}

// -------------------------------------------

void chiudiLog(FILE *f)
{
    fclose(f);
}

// -------------------------------------------

void registraLog(LPCSTR txt)
{
    FILE *f = apriLog();
    fprintf(f, "%s", txt);
    chiudiLog(f);
}

// -------------------------------------------

//
//   FUNCTION: InitInstance(HANDLE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
    HWND hWnd;
    BOOL ok = TRUE;
    char drive[_MAX_DRIVE];   
    char dir[_MAX_DIR];
    char fname[_MAX_FNAME];   
    char ext[_MAX_EXT];        
    char completo[_MAX_PATH];

    hInst = hInstance; // Store instance handle in our global variable

    // Valorizza il nome del file INI

    if (!GetModuleFileName(NULL, completo, sizeof(completo)))
    {
        errore("Error in 'GetModuleFileName()'");
        return FALSE;
    }
    
    _splitpath(completo, drive, dir, fname, ext);
    sprintf(szNomePathEseguibile, "%s%s", drive, dir);
    sprintf(szNomeFileIni, "%s%s%s.ini", drive, dir, fname);

    // Alloca spazio per gli "snapshot" dei processi
    snapshotAttuale = malloc(sizeof(*snapshotAttuale));
    snapshotPrecedente = malloc(sizeof(*snapshotPrecedente));
    memset(snapshotAttuale, 0, sizeof(*snapshotAttuale));
    memset(snapshotPrecedente, 0, sizeof(*snapshotPrecedente));

    memset(&datiPreferenze, 0, sizeof(datiPreferenze));
    leggiOpzioni();

    // Initialize language DLL for resources
    loadResourceDll();

    // Inizializza stringhe localizzate
    loadResourceString(IDS_APP_TITLE, szTitle, MAX_LOADSTRING);

    // Fa il link delle DLL necessarie alla gestione dei processi
    if (!inizializzaEnumProcs())
    {
        errore("Error loading process helper DLLs.");
        return FALSE;
    }

    hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);
    
    if (!hWnd)
    {
        return FALSE;
    }

    // Avvia il timer
    SetTimer(hWnd, 1, 2000, NULL);

    // Pone l'icona nella tray area
    //aggiornaIconaTray(hWnd);

//    ShowWindow(hWnd, nCmdShow);
//    UpdateWindow(hWnd);

    // Registra l'avvenuto START
    sprintf(completo, getResourceString(IDS_LOGSTART), 
            szWindowClass, qualeDataOra());
    registraLog(completo);

    return ok;
}

// -------------------------------------

void cleanup(HWND hWnd)
{
    NOTIFYICONDATA nid;
    int i;
    char s[256];

    // Uccide il timer
    KillTimer(hWnd, 1);

    // Toglie l'icona dalla tray area

    memset(&nid, 0, sizeof(nid));
    
    nid.cbSize = sizeof(nid);
    nid.hWnd = hWnd;
    nid.uID = 1;

    Shell_NotifyIcon(NIM_DELETE, &nid);

    // Libera la RAM

    free(datiPreferenze.lpszIntlDll);

    for (i = 0; i < NMAXPROCESSI; i++)
    {
        if (datiPreferenze.lpszNomiProcessi[i])
            free(datiPreferenze.lpszNomiProcessi[i]);
        datiPreferenze.lpszNomiProcessi[i] = NULL;
    }

    for (i = 0; i < NMAXFILES; i++)
    {
        if (datiPreferenze.lpszNomiFiles[i])
            free(datiPreferenze.lpszNomiFiles[i]);
        datiPreferenze.lpszNomiFiles[i] = NULL;
    }

    for (i = 0; i < NMAXSNAPSHOTPROCESSI; i++)
    {
        if (snapshotAttuale->processi[i])
            free(snapshotAttuale->processi[i]);
        if (snapshotPrecedente->processi[i])
            free(snapshotPrecedente->processi[i]);
    }

    // Registra la terminazione del programma
    sprintf(s, getResourceString(IDS_LOGSTOP), szWindowClass, qualeDataOra());
    registraLog(s);

    // Libera le DLL
    cleanupEnumProcs();
    unloadResourceDll();
}

// -------------------------------------

void logSnapshots(LPCSTR msg)
{
    FILE *f = apriLog();

    if (f)
    {
        int i;

        fprintf(f, "\n\n-------------- %s --------------\n", msg);

        fprintf(f, getResourceString(IDS_PRIORPROCESSLIST));
        fprintf(f, "  %s\n", snapshotPrecedente->dataOra);
        for (i = 0; i < snapshotPrecedente->nProcessi; i++)
            fprintf(f, "  [%ld]\t%s\n", snapshotPrecedente->idProcessi[i],
                    snapshotPrecedente->processi[i]);

        fprintf(f, getResourceString(IDS_PROCESSLIST));
        fprintf(f, "  %s\n", snapshotAttuale->dataOra);
        for (i = 0; i < snapshotAttuale->nProcessi; i++)
            fprintf(f, "  [%ld]\t%s\n", snapshotAttuale->idProcessi[i],
                    snapshotAttuale->processi[i]);

        chiudiLog(f);
    }
}

// -------------------------------------

void controllaFiles(HWND hWnd)
{
    static BOOL inControllo = 0;

    if (datiPreferenze.fFilesOn && !inControllo)
    {
        WIN32_FIND_DATA wfd;
        int i;

        inControllo = TRUE;

        for (i = 0; i < datiPreferenze.nFiles; i++)
        {
            LPCSTR f = datiPreferenze.lpszNomiFiles[i];
            if (*f)
            {
                HANDLE h = FindFirstFile(f, &wfd);
                if (h != INVALID_HANDLE_VALUE) // Beccato!!!
                {
                    TCHAR s[512];

                    fWarning = TRUE;
                    sprintf(s, getResourceString(IDS_FILEWARNING),
                               qualeDataOra(), f);
                    logSnapshots(s);

                    strcat(s, getResourceString(IDS_SHALLCONTINUEWATCH));

                    SetForegroundWindow(hWnd);
                    if (!sicuro(s))
                        datiPreferenze.lpszNomiFiles[i][0] = '\0';

                    messaggio(getResourceString(IDS_PROCESSLISTLOGGED));
                }
            }
        }

        inControllo = FALSE;
    }
}

// -------------------------------------

BOOL CALLBACK controllaProcesso(DWORD id, WORD id16, 
                                LPCSTR lpszFileName, LPARAM lp)
{
    char drive[_MAX_DRIVE];   
    char dir[_MAX_DIR];
    char fname[_MAX_FNAME];   
    char ext[_MAX_EXT];        
    char nome[_MAX_FNAME+_MAX_EXT+1];
    int i;

    i = snapshotAttuale->nProcessi;

    // Evita overflow

    if (i >= NMAXSNAPSHOTPROCESSI-2)
    {
        sprintf(nome, 
                "\n##### (%s) WARNING: process list is "
                "incomplete! (no. of processes > %d) #####\n",
                qualeDataOra(), NMAXSNAPSHOTPROCESSI);
        registraLog(nome);
        return FALSE;
    }

    // Aggiorna lo snapshot attuale

    if (!snapshotAttuale->processi[i] ||
        id != snapshotAttuale->idProcessi[i] ||
        strcmp(lpszFileName, snapshotAttuale->processi[i]))
    {
        int l = strlen(lpszFileName) + 1;

        if (snapshotAttuale->processi[i])
            free(snapshotAttuale->processi[i]);

        snapshotAttuale->processi[i] = malloc(l);
        strcpy(snapshotAttuale->processi[i], lpszFileName);
        snapshotAttuale->idProcessi[i] = id;
    }
    snapshotAttuale->nProcessi++;

    // Verifica l'eventuale esistenza del processo nella lista da controllare

    _splitpath(lpszFileName, drive, dir, fname, ext);
    sprintf(nome, "%s%s", fname, ext);

    for (i = 0; i < datiPreferenze.nProcessi; i++)
    {
        LPCSTR f = datiPreferenze.lpszNomiProcessi[i];
        if (*f)
        {
            if (!stricmp(nome, f))
            {
                TCHAR s[512];

                fWarning = TRUE;
                sprintf(s, getResourceString(IDS_PROCESSWARNING),
                           qualeDataOra(), f, id);
                logSnapshots(s);
                strcat(s, getResourceString(IDS_SHALLCONTINUEWATCH));

                SetForegroundWindow((HWND)lp);
                if (!sicuro(s))
                    datiPreferenze.lpszNomiProcessi[i][0] = '\0';

                messaggio(getResourceString(IDS_PROCESSLISTLOGGED));
            }
        }
    }

    return TRUE;
}

// ----------------

void controllaProcessi(hWnd)
{
    static BOOL inControllo = FALSE;

    if (datiPreferenze.fProcessiOn && !inControllo)
    {
        SnapshotProcessi *sp = snapshotPrecedente;

        // Scambia di posto i due snapshot
        snapshotPrecedente = snapshotAttuale;
        snapshotAttuale = sp;

        inControllo = TRUE;

        snapshotAttuale->nProcessi = 0; // Resetta il contatore
        sprintf(snapshotAttuale->dataOra, qualeDataOra());

        EnumProcs(controllaProcesso, (LPARAM)hWnd);

        inControllo = FALSE;
    }
}

// -------------------------------------

//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message) 
    {
    case WM_CREATE:
        if (!datiPreferenze.fInizializzato)
            PostMessage(hWnd, WM_COMMAND, MAKEWPARAM(IDM_OPZIONI, 0), 0);
        break;

    case WM_TIMER:
        aggiornaIconaTray(hWnd);
        controllaProcessi(hWnd);
        controllaFiles(hWnd);
        break;

    case UWM_NOTIFICAICONA:
        {
            // Messaggio dalla tray icon

            switch (lParam)
            {
            case WM_RBUTTONUP:
                {
                    //HMENU hMenu = GetMenu(hWnd);
                    HMENU hPopup = GetSubMenu(hMenu, 0);

			        // Get the current cursor position, to display the menu at
			        POINT mouse;
			        GetCursorPos(&mouse);

                    SetMenuDefaultItem(hPopup, 0, TRUE);
			        
			        // There's a "bug"
			        // (Microsoft calls it a feature) in Windows 95 that requires calling
			        // SetForegroundWindow. To find out more, search for Q135788 in MSDN.
			        //
			        SetForegroundWindow(hWnd);

			        // Display the menu at the desired position
			        TrackPopupMenu(hPopup, TPM_LEFTBUTTON|TPM_RIGHTBUTTON, 
                                   mouse.x, mouse.y, 0, hWnd, NULL);
                    break;
                }
            case WM_LBUTTONDBLCLK:
                PostMessage(hWnd, WM_COMMAND, MAKEWPARAM(IDM_OPZIONI, 0), 0);
                SetForegroundWindow(hWnd);
                break;
            }
            break;
        }

    case WM_COMMAND:
        {
            WORD wmId    = LOWORD(wParam),
                 wmEvent = HIWORD(wParam); 
            // Parse the menu selections:
            switch (wmId)
            {
            case IDM_ABOUT:
                DialogBox(hInstIntlDll, (LPCTSTR)IDD_ABOUTBOX, 
                          hWnd, (DLGPROC)About);
                break;

            case IDM_VISUALIZZALOG:
                {
                    TCHAR s[_MAX_PATH];
                    sprintf(s, "NOTEPAD %s%s.LOG", 
                            szNomePathEseguibile, szWindowClass);
                    WinExec(s, SW_SHOW);
                    break;
                }

            case IDM_ELENCOPROCESSI:
                DialogBox(hInstIntlDll, (LPCTSTR)IDD_DIALOGLISTAPROCESSI, 
                          hWnd, (DLGPROC)fnDlgElencoProcessi);
                break;

            case IDM_OPZIONI:
                DialogBox(hInstIntlDll, (LPCTSTR)IDD_OPZIONI, hWnd, 
                          (DLGPROC)fnDlgOpzioni);
                break;

            case IDM_EXIT:
                DestroyWindow(hWnd);
                break;

            default:
                return DefWindowProc(hWnd, message, wParam, lParam);
            }
            break;
        }

    case WM_PAINT:
        break;

    case WM_DESTROY:
        cleanup(hWnd);
        PostQuitMessage(0);
        break;

    default:
        return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return 0;
}

// ----------------------------------------------------------------------

// Mesage handler for about box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
    case WM_INITDIALOG:
        {
            HWND hEdit1 = GetDlgItem(hDlg, IDC_EDIT1);
            Edit_SetText(hEdit1, getResourceString(IDS_EXPLANATION));
            return TRUE;
        }
        
    case WM_COMMAND:
        if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
        {
            EndDialog(hDlg, LOWORD(wParam));
            return TRUE;
        }
        break;
    }
    return FALSE;
}

// ----------------------------------------------------------------------

BOOL CALLBACK aggiungiProcesso(DWORD id, WORD id16, 
                               LPCSTR lpszFileName, LPARAM lp)
{
    HWND hLista = (HWND)lp;
    
    char s[500];
    sprintf(s, "%ld [%u]: %s", id, id16, lpszFileName);
    
    ListBox_AddString(hLista, s);
    return TRUE;
}

// ----------------------------------------------------------------------

// Aggiorna le liste elenco processi per il dialog indicato
void aggiornaListeElencoProcessi(HWND hDlg)
{
    static BOOL inLista = FALSE;
    HWND hLista = GetDlgItem(hDlg, IDC_LIST1);
    int top,
        curSel;

    if (inLista)
        return;

    inLista = TRUE;

    if (!hLista)
        erroreWindows("GetDlgItem(hDlg, IDC_LIST1)");
    
    top = ListBox_GetTopIndex(hLista);
    curSel = ListBox_GetCurSel(hLista);

    SetWindowRedraw(hLista, FALSE);
    ListBox_ResetContent(hLista);
    
    EnumProcs(aggiungiProcesso, (LPARAM)hLista);

    SetWindowRedraw(hLista, TRUE);
    ListBox_SetTopIndex(hLista, top);
    ListBox_SetCurSel(hLista, curSel);

    inLista = FALSE;
}

// ----------------------------------------------------------------------

// Message handler per il dialog con l'elenco processi
LRESULT CALLBACK fnDlgElencoProcessi(HWND hDlg, UINT message, 
                                     WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
    case WM_INITDIALOG:
        aggiornaListeElencoProcessi(hDlg);
        SetTimer(hDlg, 1, 1000, NULL);
        return TRUE;
        
    case WM_TIMER:
        aggiornaListeElencoProcessi(hDlg);
        break;

    case WM_COMMAND:
        if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
        {
            KillTimer(hDlg, 1);
            EndDialog(hDlg, LOWORD(wParam));
            return TRUE;
        }
        break;
    }
    return FALSE;
}

// ----------------------------------------------------------------------

// Legge le preferenze dal registry
void leggiOpzioni(void)
{
    int n;

    LEGGIOPZIONEINT(fInizializzato);
    LEGGIOPZIONEINT(fProcessiOn);
    LEGGIOPZIONEINT(fFilesOn);
    LEGGIOPZIONEINT(nProcessi);
    LEGGIOPZIONEINT(nFiles);

    LEGGIOPZIONESTRINGA(lpszIntlDll);

    for (n = 0; n < datiPreferenze.nProcessi; n++)
        LEGGIOPZIONESTRINGA_IDX(lpszNomiProcessi, n);

    for (n = 0; n < datiPreferenze.nFiles; n++)
        LEGGIOPZIONESTRINGA_IDX(lpszNomiFiles, n);
}

// ----------------------------------------------------------------------

// Memorizza le preferenze dal dialog opzioni
void memorizzaOpzioni(HWND hDlg)
{
    BOOL fItalianLanguage = Button_GetCheck(GetDlgItem(hDlg, 
                                            IDC_ITALIANLANGUAGE));
    BOOL fProcessiOn = Button_GetCheck(GetDlgItem(hDlg, IDC_PROCESSI_ONOFF)),
         fFilesOn = Button_GetCheck(GetDlgItem(hDlg, IDC_FILES_ONOFF));
    HWND hListaProcessi = GetDlgItem(hDlg, IDC_LISTAPROCESSI),
         hListaFiles = GetDlgItem(hDlg, IDC_LISTAFILES);

    int i,
        n = ListBox_GetCount(hListaProcessi);

    datiPreferenze.fInizializzato = TRUE;

    strcpy(datiPreferenze.lpszIntlDll, "");
    if (fItalianLanguage)
        strcpy(datiPreferenze.lpszIntlDll, "IT");

    datiPreferenze.fProcessiOn = fProcessiOn;
    datiPreferenze.fFilesOn = fFilesOn;

    SCRIVIOPZIONEINT(fInizializzato);
    SCRIVIOPZIONEINT(fProcessiOn);
    SCRIVIOPZIONEINT(fFilesOn);

    SCRIVIOPZIONESTRINGA(lpszIntlDll);

    if (n > NMAXPROCESSI)
    {
        char s[256];
        n = NMAXPROCESSI;
        sprintf(s, getResourceString(IDS_NMAXPROCESSESREACHED), n);
        errore(s);
    }

    // ------- Lettura dai preferenze processi

    datiPreferenze.nProcessi = n;
    SCRIVIOPZIONEINT(nProcessi);

    for (i = 0; i < NMAXPROCESSI; i++)
    {
        if (datiPreferenze.lpszNomiProcessi[i])
            free(datiPreferenze.lpszNomiProcessi[i]);
        datiPreferenze.lpszNomiProcessi[i] = NULL;

        if (i < n)
        {
            int l = ListBox_GetTextLen(hListaProcessi, i) + 1;
            LPSTR s = malloc(l);
            ListBox_GetText(hListaProcessi, i, s);
            datiPreferenze.lpszNomiProcessi[i] = s;
            SCRIVIOPZIONESTRINGA_IDX(lpszNomiProcessi, i);
        }
    }

    // ------- Lettura dai preferenze files

    n = ListBox_GetCount(hListaFiles);
    if (n > NMAXFILES)
    {
        char s[256];
        n = NMAXFILES;
        sprintf(s, getResourceString(IDS_NMAXFILESREACHED), n);
        errore(s);
    }
    datiPreferenze.nFiles = n;
    SCRIVIOPZIONEINT(nFiles);

    for (i = 0; i < NMAXFILES; i++)
    {
        if (datiPreferenze.lpszNomiFiles[i])
            free(datiPreferenze.lpszNomiFiles[i]);
        datiPreferenze.lpszNomiFiles[i] = NULL;

        if (i < n)
        {
            int l = ListBox_GetTextLen(hListaFiles, i) + 1;
            LPSTR s = malloc(l);
            ListBox_GetText(hListaFiles, i, s);
            datiPreferenze.lpszNomiFiles[i] = s;
            SCRIVIOPZIONESTRINGA_IDX(lpszNomiFiles, i);
        }
    }
}

// ----------------------------------------------------------------------

// Attiva/disattiva alcuni control del dialog opzioni
void verificaControlliDlgOpzioni(HWND hDlg)
{
    BOOL fProcessiOn = Button_GetCheck(GetDlgItem(hDlg, IDC_PROCESSI_ONOFF)),
         fFilesOn = Button_GetCheck(GetDlgItem(hDlg, IDC_FILES_ONOFF));

    EnableWindow(GetDlgItem(hDlg, IDC_AGGIUNGIPROCESSO), fProcessiOn);
    EnableWindow(GetDlgItem(hDlg, IDC_ELIMINAPROCESSO), fProcessiOn);
    EnableWindow(GetDlgItem(hDlg, IDC_LISTAPROCESSI), fProcessiOn);
    EnableWindow(GetDlgItem(hDlg, IDC_TESTOLISTAPROCESSI), fProcessiOn);

    EnableWindow(GetDlgItem(hDlg, IDC_AGGIUNGIFILE), fFilesOn);
    EnableWindow(GetDlgItem(hDlg, IDC_ELIMINAFILE), fFilesOn);
    EnableWindow(GetDlgItem(hDlg, IDC_LISTAFILES), fFilesOn);
    EnableWindow(GetDlgItem(hDlg, IDC_TESTOLISTAFILES), fFilesOn);
}

// ----------------------------------------------------------------------

// Message handler per il dialog opzioni
LRESULT CALLBACK fnDlgOpzioni(HWND hDlg, UINT message, 
                              WPARAM wParam, LPARAM lParam)
{
    HWND hListaProcessi = GetDlgItem(hDlg, IDC_LISTAPROCESSI),
         hListaFiles = GetDlgItem(hDlg, IDC_LISTAFILES);

    switch (message)
    {
    case WM_INITDIALOG:
        {
            int i;
            BOOL fDefaultLanguage = FALSE,
                 fItalianLanguage = FALSE;
            LPCSTR s = datiPreferenze.lpszIntlDll;

            fDefaultLanguage = !(*s);
            if (!fDefaultLanguage)
                fItalianLanguage = !stricmp(s, "IT");
            fDefaultLanguage = !fItalianLanguage;

            // Valorizza i control del dialogo
            Button_SetCheck(GetDlgItem(hDlg, IDC_DEFAULTLANGUAGE), 
                            fDefaultLanguage);
            Button_SetCheck(GetDlgItem(hDlg, IDC_ITALIANLANGUAGE), 
                            fItalianLanguage);
            Button_SetCheck(GetDlgItem(hDlg, IDC_PROCESSI_ONOFF), 
                            datiPreferenze.fProcessiOn);
            Button_SetCheck(GetDlgItem(hDlg, IDC_FILES_ONOFF), 
                            datiPreferenze.fFilesOn);
            for (i = 0; i < datiPreferenze.nProcessi; i++)
                ListBox_AddString(hListaProcessi,
                                  datiPreferenze.lpszNomiProcessi[i]);
            for (i = 0; i < datiPreferenze.nFiles; i++)
                ListBox_AddString(hListaFiles,
                                  datiPreferenze.lpszNomiFiles[i]);
            verificaControlliDlgOpzioni(hDlg);
            return TRUE;
        }
        
    case WM_COMMAND:
        {
            char s[256];
            WORD w = LOWORD(wParam);

            switch (w)
            {
            case IDOK:
                memorizzaOpzioni(hDlg);
                loadResourceDll();
                // Fall through
            case IDCANCEL:
                EndDialog(hDlg, w);
                break;

            case IDC_PROCESSI_ONOFF:
            case IDC_FILES_ONOFF:
                verificaControlliDlgOpzioni(hDlg);
                break;

            case IDC_AGGIUNGIPROCESSO:
                {
                    char msg[120],
                         t[120];
                    strcpy(msg, getResourceString(IDS_PROCESSNAMEPROMPT));
                    strcpy(t, getResourceString(IDS_PROCESSNAMEPROMPTTITLE));
                    strcpy(s, inputStringa(hDlg, msg, t, ""));
                    if (s[0])
                        ListBox_AddString(hListaProcessi, s);
                    break;
                }

            case IDC_AGGIUNGIFILE:
                {
                    char msg[120],
                         t[120];
                    strcpy(msg, getResourceString(IDS_FILENAMEPROMPT));
                    strcpy(t, getResourceString(IDS_FILENAMEPROMPTTITLE));
                    strcpy(s, inputStringa(hDlg, msg, t, ""));
                    if (s[0])
                        ListBox_AddString(hListaFiles, s);
                    break;
                }

            case IDC_ELIMINAPROCESSO:
                {
                    int n = ListBox_GetCurSel(hListaProcessi);
                    ListBox_DeleteString(hListaProcessi, n);
                    break;
                }

            case IDC_ELIMINAFILE:
                {
                    int n = ListBox_GetCurSel(hListaFiles);
                    ListBox_DeleteString(hListaFiles, n);
                    break;
                }
            }

            return TRUE;
        }
    }
    return FALSE;
}
// ----------------------------------------------------------------------

// Message handler per il dialog di input
LRESULT CALLBACK fnDlgInput(HWND hDlg, UINT message, 
                            WPARAM wParam, LPARAM lParam)
{
    static DatiInputStringa *d = NULL;

    switch (message)
    {
    case WM_INITDIALOG:
        {
            d = (DatiInputStringa *)lParam;
            Static_SetText(GetDlgItem(hDlg, IDC_PROMPT), d->prompt);
            Edit_SetText(GetDlgItem(hDlg, IDC_VALORE), d->valore);
            SetWindowText(hDlg, d->titolo);
            return TRUE;
        }
        
    case WM_COMMAND:
        {
            WORD w = LOWORD(wParam);

            switch (w)
            {
            case IDOK:
                Edit_GetText(GetDlgItem(hDlg, IDC_VALORE), d->valore, 256);
                // Fall through
            case IDCANCEL:
                EndDialog(hDlg, w);
                break;
            }

            return TRUE;
        }
    }
    return FALSE;
}
